/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.MainScreen;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputPathScreen
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 9123437910569838861L;
    private static final String sCommandBrowse = "BROWSE";
    private JTextField aUserInputPath;

    public InputPathScreen(ActionListener actionListener) {
        this.InitScreen(actionListener);
    }

    private void InitScreen(ActionListener actionListener) {
        JLabel jLabel = MainScreen.getLabel("SETUP STEP 1: Specify Location", 16, 1, true);
        JLabel jLabel2 = MainScreen.getLabel("Enter the location you want to put the SDK tool:", 14, 0, true);
        this.aUserInputPath = new JTextField(30);
        this.aUserInputPath.setToolTipText("Enter the location you want to put the SDK tool");
        this.aUserInputPath.setText(ConfigData.sSDKLocation);
        this.aUserInputPath.addActionListener(this);
        JButton jButton = new JButton("Browse...");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('B');
        jButton.setActionCommand(sCommandBrowse);
        jButton.addActionListener(this);
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 17);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.add(jLabel2);
        gridBagConstraints = MainScreen.createGridBagConstraints(1, 0, n, 0, 22);
        gridBagLayout.setConstraints(this.aUserInputPath, gridBagConstraints);
        this.add(this.aUserInputPath);
        gridBagConstraints = MainScreen.createGridBagConstraints(1, 1, n++, 0, 21);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandBrowse)) {
            this.selectDirectories();
            this.aUserInputPath.setText(ConfigData.sSDKLocation);
        } else {
            ConfigData.updateSDKPath(this.aUserInputPath.getText());
        }
    }

    private void selectDirectories() {
        File file = null;
        JFileChooser jFileChooser = null;
        jFileChooser = ConfigData.sSDKLocation.equalsIgnoreCase("") ? new JFileChooser() : new JFileChooser(new File(ConfigData.sSDKLocation));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setDialogTitle("Choose SDK Location");
        if (jFileChooser.showOpenDialog(this) != 1) {
            file = jFileChooser.getSelectedFile();
            ConfigData.updateSDKPath(file.getAbsolutePath());
        }
    }

    public boolean isPathValid() {
        if (ConfigData.sSDKLocation.equalsIgnoreCase("")) {
            return false;
        }
        ConfigData.updateSDKPath(this.aUserInputPath.getText());
        return true;
    }

    public boolean validateData() {
        boolean bl = true;
        return bl;
    }
}

